/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaModelUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CollisionFileReader {
    private static Map<String, CollisionItem> collisionMap = new HashMap<String, CollisionItem>();
    public static Path COLLISION_FILES = Platform.getConfigFolder().resolve("./com.yuushya/");

    public static void readAllFileSelf() {
        Set<String> set = YuushyaRegistries.BlockALL.keySet();
        for (String name : set) {
            try {
                InputStream inputStream = CollisionFileReader.class.getResourceAsStream("/data/yuushya/collision/" + name + ".json");
                try {
                    if (inputStream == null) continue;
                    JsonElement jsonElement = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    CollisionFileReader.getCollisionMap().put(new ResourceLocation("yuushya", name).toString(), collision);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllFileFromConfig() {
        if (Files.exists(COLLISION_FILES, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(COLLISION_FILES);){
                for (Path path : paths) {
                    String namespace = path.getFileName().toString();
                    Path newPath = path.resolve("./data/" + namespace + "/collision/");
                    DirectoryStream<Path> collisionFiles = Files.newDirectoryStream(newPath);
                    try {
                        for (Path collisionFile : collisionFiles) {
                            String id = collisionFile.getFileName().toString().replace(".json", "");
                            if (!Files.exists(collisionFile, new LinkOption[0])) continue;
                            try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new FileReader(collisionFile.toFile(), StandardCharsets.UTF_8)));){
                                CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(JsonParser.parseReader((JsonReader)reader), CollisionItem.class);
                                CollisionFileReader.getCollisionMap().put(new ResourceLocation(namespace, id).toString(), collision);
                                if (collision.children == null) continue;
                                for (String namespaceId : collision.children) {
                                    CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                                }
                            }
                        }
                    }
                    finally {
                        if (collisionFiles == null) continue;
                        collisionFiles.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllCollision() {
        CollisionFileReader.getCollisionMap().forEach((key, value) -> CollisionFileReader.readCollisionToVoxelShape(key));
    }

    public static void readCollisionToVoxelShape(Map<BlockState, VoxelShape> cache, Block block, String namespaceid) {
        CollisionItem collision;
        if (!(block instanceof AirBlock) && (collision = CollisionFileReader.getCollisionMap().get(namespaceid)) != null && collision.blockstates != null) {
            for (CollisionItem.Model variant : collision.blockstates) {
                List<BlockState> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant.variant);
                VoxelShape shape = CollisionFileReader.getVoxelShape(variant);
                for (BlockState blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(Block.m_49956_((BlockState)blockstate), shape);
                    cache.put(blockstate, shape);
                }
            }
        }
    }

    public static void readCollisionToVoxelShape(String namespaceid) {
        Block block;
        CollisionItem collision = CollisionFileReader.getCollisionMap().get(namespaceid);
        if (collision != null && collision.blockstates != null && !((block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(namespaceid))) instanceof AirBlock)) {
            for (CollisionItem.Model variant : collision.blockstates) {
                List<BlockState> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant.variant);
                VoxelShape shape = CollisionFileReader.getVoxelShape(variant);
                for (BlockState blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(Block.m_49956_((BlockState)blockstate), shape);
                }
            }
        }
    }

    public static VoxelShape getVoxelShape(CollisionItem.Model model) {
        VoxelShape shape = Shapes.m_83040_();
        if (model.collision == null) {
            return Shapes.m_83144_();
        }
        for (CollisionItem.Model.Element cube : model.collision) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)cube.from.get(0), (double)cube.from.get(1), (double)cube.from.get(2), (double)cube.to.get(0), (double)cube.to.get(1), (double)cube.to.get(2)));
        }
        if ((shape = shape.m_83296_()).m_83281_()) {
            return Shapes.m_83144_();
        }
        return shape;
    }

    public static Map<String, CollisionItem> getCollisionMap() {
        return collisionMap;
    }

    public static void setCollisionMap(Map<String, CollisionItem> collisionMap) {
        CollisionFileReader.collisionMap = collisionMap;
    }
}

